<?php
require_once __DIR__.'/config.php';

function zarin_request(int $amount_rial, string $callback_url, string $desc='خرید شماره مجازی'): array {
  $payload = [
    'merchant_id' => ZARINPAL_MERCHANT,
    'amount'      => $amount_rial,
    'callback_url'=> $callback_url,
    'description' => $desc,
  ];
  $ch = curl_init('https://api.zarinpal.com/pg/v4/payment/request.json');
  curl_setopt_array($ch,[
    CURLOPT_RETURNTRANSFER=>true,
    CURLOPT_TIMEOUT=>20,
    CURLOPT_POST=>true,
    CURLOPT_HTTPHEADER=>['Content-Type: application/json'],
    CURLOPT_POSTFIELDS=>json_encode($payload, JSON_UNESCAPED_UNICODE),
  ]);
  $res = curl_exec($ch);
  if ($res === false) return ['ok'=>false,'err'=>'curl'];
  $data = json_decode($res,true);
  if (!isset($data['data']) || !isset($data['data']['authority'])) {
    return ['ok'=>false,'err'=>$res];
  }
  return ['ok'=>true,'authority'=>$data['data']['authority']];
}

function zarin_verify(string $authority, int $amount_rial): array {
  $payload = [
    'merchant_id'=> ZARINPAL_MERCHANT,
    'authority'  => $authority,
    'amount'     => $amount_rial,
  ];
  $ch = curl_init('https://api.zarinpal.com/pg/v4/payment/verify.json');
  curl_setopt_array($ch,[
    CURLOPT_RETURNTRANSFER=>true,
    CURLOPT_TIMEOUT=>20,
    CURLOPT_POST=>true,
    CURLOPT_HTTPHEADER=>['Content-Type: application/json'],
    CURLOPT_POSTFIELDS=>json_encode($payload, JSON_UNESCAPED_UNICODE),
  ]);
  $res = curl_exec($ch);
  if ($res === false) return ['ok'=>false,'err'=>'curl'];
  $data = json_decode($res,true);
  if (isset($data['data']) && isset($data['data']['code']) && (int)$data['data']['code'] === 100) {
    return ['ok'=>true,'ref_id'=>$data['data']['ref_id']];
  }
  return ['ok'=>false,'err'=>$res];
}
